
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
basil = m.addVar(vtype=gp.GRB.INTEGER, name="basil")
aloe = m.addVar(vtype=gp.GRB.INTEGER, name="aloe")
verbenas = m.addVar(vtype=gp.GRB.INTEGER, name="verbenas")
lilies = m.addVar(vtype=gp.GRB.INTEGER, name="lilies")
boxwoods = m.addVar(vtype=gp.GRB.INTEGER, name="boxwoods")


# Set objective function
m.setObjective(6*basil**2 + 5*basil*aloe + 2*basil*verbenas + 8*basil*lilies + 8*basil*boxwoods + 4*aloe*boxwoods + 2*verbenas*boxwoods + 5*boxwoods**2, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(7.32*basil + 3.9*aloe + 8.0*verbenas >= 9)
m.addConstr(7.32*basil + 3.9*aloe + 8.97*lilies >= 9)
m.addConstr(8.0**2*verbenas + 8.97**2*lilies + 3.0**2*boxwoods >= 9)
m.addConstr(7.32**2*basil + 3.9**2*aloe + 8.0**2*verbenas >= 17)
m.addConstr(7.32**2*basil + 3.9**2*aloe + 8.97**2*lilies >= 17)
m.addConstr(8.0**2*verbenas + 8.97**2*lilies + 3.0**2*boxwoods >= 17)
m.addConstr(7.32**2*basil + 3.9**2*aloe + 8.0**2*verbenas >= 15)
m.addConstr(7.32*basil + 3.9*aloe + 8.97*lilies >= 15)
m.addConstr(8.0**2*verbenas + 8.97**2*lilies + 3.0**2*boxwoods >= 15)
m.addConstr(3.03*aloe + 5.36*lilies >= 13)
m.addConstr(3.03**2*aloe + 1.2**2*verbenas >= 17)
m.addConstr(1.2**2*verbenas + 5.36**2*lilies >= 14)
m.addConstr(8.99*basil + 1.2*verbenas + 8.38*boxwoods >= 11)
m.addConstr(3.7*basil + 6.61*verbenas >= 16)
m.addConstr(0.49*aloe + 5.81*boxwoods >= 16)
m.addConstr(6.61*verbenas + 8.46*lilies >= 33)
m.addConstr(6.61**2*verbenas + 5.81**2*boxwoods >= 16)
m.addConstr(3.7*basil + 5.81*boxwoods >= 28)
m.addConstr(3.7*basil + 8.46*lilies >= 19)
m.addConstr(3.7*basil + 8.46*lilies + 5.81*boxwoods >= 28)
m.addConstr(7*aloe**2 - lilies**2 - 2*boxwoods**2 >= 0)
m.addConstr(3.9*aloe + 3.0*boxwoods <= 45)
m.addConstr(3.9*aloe + 8.0*verbenas <= 30)
m.addConstr(3.9**2*aloe + 8.97**2*lilies <= 50)
m.addConstr(8.0**2*verbenas + 8.97**2*lilies <= 66)
m.addConstr(8.0*verbenas + 3.0*boxwoods <= 21)
m.addConstr(7.32*basil + 3.0*boxwoods <= 83)
m.addConstr(7.32*basil + 8.97*lilies <= 28)
m.addConstr(7.32*basil + 8.0*verbenas <= 38)
m.addConstr(7.32*basil + 3.9*aloe + 8.0*verbenas + 8.97*lilies + 3.0*boxwoods <= 38)
m.addConstr(1.2**2*verbenas + 5.36**2*lilies <= 65)
m.addConstr(3.03**2*aloe + 5.36**2*lilies <= 37)
m.addConstr(3.03*aloe + 1.2*verbenas <= 86)
m.addConstr(8.99*basil + 8.38*boxwoods <= 63)
m.addConstr(1.2*verbenas + 8.38*boxwoods <= 72)
m.addConstr(5.36*lilies + 8.38*boxwoods <= 94)
m.addConstr(8.99*basil + 3.03*aloe + 1.2*verbenas + 5.36*lilies + 8.38*boxwoods <= 94)
m.addConstr(0.49**2*aloe + 5.81**2*boxwoods <= 129)
m.addConstr(3.7*basil + 0.49*aloe <= 57)
m.addConstr(6.61*verbenas + 8.46*lilies <= 126)
m.addConstr(3.7*basil + 0.49*aloe + 6.61*verbenas + 8.46*lilies + 5.81*boxwoods <= 126)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

