
import gurobipy as gp

# Create a new model
m = gp.Model("fruit_optimization")

# Create variables
strawberries = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
cantaloupes = m.addVar(vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
kiwis = m.addVar(vtype=gp.GRB.INTEGER, name="kiwis")

# Set objective function
m.setObjective(2.98 * strawberries + 3.42 * cantaloupes + 2.74 * kiwis, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(4 * strawberries + 6 * cantaloupes >= 30, "iron_constraint1")
m.addConstr(4 * strawberries + 6 * cantaloupes + 5 * kiwis >= 30, "iron_constraint2")
m.addConstr(11 * strawberries + 10 * cantaloupes >= 22, "protein_constraint1")
m.addConstr(11 * strawberries + 1 * kiwis >= 17, "protein_constraint2")
m.addConstr(11 * strawberries + 10 * cantaloupes + 1 * kiwis >= 17, "protein_constraint3")
m.addConstr(-2 * strawberries + 4 * kiwis >= 0, "strawberry_kiwi_constraint")
m.addConstr(4 * strawberries + 6 * cantaloupes + 5 * kiwis <= 98, "iron_constraint3")
m.addConstr(11 * strawberries + 1 * kiwis <= 74, "protein_constraint4")
m.addConstr(10 * cantaloupes + 1 * kiwis <= 67, "protein_constraint5")

# Resource Constraints (implicit in the problem description)
m.addConstr(4 * strawberries <= 199, "iron_resource_strawberries")
m.addConstr(11 * strawberries <= 148, "protein_resource_strawberries")
m.addConstr(6 * cantaloupes <= 199, "iron_resource_cantaloupes")
m.addConstr(10 * cantaloupes <= 148, "protein_resource_cantaloupes")
m.addConstr(5 * kiwis <= 199, "iron_resource_kiwis")
m.addConstr(1 * kiwis <= 148, "protein_resource_kiwis")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('strawberries:', strawberries.x)
    print('cantaloupes:', cantaloupes.x)
    print('kiwis:', kiwis.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
