
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x0 = model.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
x1 = model.addVar(name="cantaloupes", vtype=gurobi.GRB.CONTINUOUS)
x2 = model.addVar(name="kiwis", vtype=gurobi.GRB.INTEGER)

# Define the objective function
model.setObjective(2.98 * x0 + 3.42 * x1 + 2.74 * x2, gurobi.GRB.MINIMIZE)

# Add constraints
model.addConstr(4 * x0 + 6 * x1 >= 30)
model.addConstr(4 * x0 + 6 * x1 + 5 * x2 >= 30)
model.addConstr(11 * x0 + 10 * x1 >= 22)
model.addConstr(11 * x0 + x2 >= 17)
model.addConstr(11 * x0 + 10 * x1 + x2 >= 17)
model.addConstr(-2 * x0 + 4 * x2 >= 0)
model.addConstr(4 * x0 + 6 * x1 + 5 * x2 <= 98)
model.addConstr(11 * x0 + x2 <= 74)
model.addConstr(10 * x1 + x2 <= 67)

# Update the model
model.update()

# Solve the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Strawberries: ", x0.varValue)
    print("Cantaloupes: ", x1.varValue)
    print("Kiwis: ", x2.varValue)
else:
    print("The model is infeasible")
