
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("resource_allocation")

    # Create variables
    ringo_hours = m.addVar(lb=0, name="ringo_hours")
    george_hours = m.addVar(lb=0, name="george_hours")


    # Set objective function
    m.setObjective(1.21 * ringo_hours + 9.67 * george_hours, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(25 * ringo_hours + 18 * george_hours >= 59, "dollar_cost_min")
    m.addConstr(24 * ringo_hours + 5 * george_hours >= 38, "paperwork_rating_min")
    m.addConstr(7 * ringo_hours - george_hours >= 0, "ringo_george_ratio")
    m.addConstr(25 * ringo_hours + 18 * george_hours <= 87, "dollar_cost_max")
    m.addConstr(24 * ringo_hours + 5 * george_hours <= 149, "paperwork_rating_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == gp.GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Hours worked by Ringo: {ringo_hours.x}")
        print(f"Hours worked by George: {george_hours.x}")
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
