
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Ringo")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_George")

# Define objective function
m.setObjective(1.21*x1 + 9.67*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(25*x1 + 18*x2 >= 59, "dollar_cost_constraint")
m.addConstr(24*x1 + 5*x2 >= 38, "paperwork_competence_constraint")
m.addConstr(7*x1 - x2 >= 0, "ringo_george_hours_constraint")
m.addConstr(25*x1 + 18*x2 <= 87, "max_dollar_cost_constraint")
m.addConstr(24*x1 + 5*x2 <= 149, "max_paperwork_competence_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Ringo: {x1.x}")
    print(f"Hours worked by George: {x2.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
