
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name='hours_worked_by_Ringo', lb=0)  # Assuming hours cannot be negative
    x2 = model.addVar(name='hours_worked_by_George', lb=0)  # Assuming hours cannot be negative

    # Define the objective function
    model.setObjective(1.21*x1 + 9.67*x2, gurobi.GRB.MINIMIZE)

    # Define the constraints
    model.addConstr(25*x1 + 18*x2 >= 59, name='total_dollar_cost')
    model.addConstr(24*x1 + 5*x2 >= 38, name='total_paperwork_competence')
    model.addConstr(7*x1 - x2 >= 0, name='Ringo_George_hours')
    model.addConstr(25*x1 + 18*x2 <= 87, name='total_dollar_cost_upper_bound')
    model.addConstr(24*x1 + 5*x2 <= 149, name='total_paperwork_competence_upper_bound')

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Ringo: {x1.varValue}')
        print(f'Hours worked by George: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
