
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("food_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.INTEGER, name="strawberries")
    x1 = m.addVar(vtype=gp.GRB.INTEGER, name="chicken breasts")
    x2 = m.addVar(vtype=gp.GRB.INTEGER, name="bowls of instant ramen")


    # Set objective function
    m.setObjective(4*x0 + 6*x1 + x2, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(6*x0 + 6*x2 >= 13, "c0")
    m.addConstr(6*x0 + 8*x1 >= 10, "c1")
    m.addConstr(3*x0 + 6*x1 >= 4, "c2")
    m.addConstr(3*x0 + 7*x2 >= 6, "c3")
    m.addConstr(3*x0 + 6*x1 + 7*x2 >= 11, "c4")
    m.addConstr(10*x1 - 3*x2 >= 0, "c5")
    m.addConstr(6*x0 + 8*x1 <= 46, "c6")
    m.addConstr(6*x0 + 6*x2 <= 44, "c7")
    m.addConstr(6*x0 + 8*x1 + 6*x2 <= 44, "c8")
    m.addConstr(3*x0 + 7*x2 <= 17, "c9")
    m.addConstr(3*x0 + 6*x1 <= 22, "c10")
    m.addConstr(3*x0 + 6*x1 + 7*x2 <= 22, "c11")



    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Objective Value:', m.objVal)
        print('Strawberries:', x0.x)
        print('Chicken Breasts:', x1.x)
        print('Bowls of Instant Ramen:', x2.x)
    elif m.status == gp.GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization ended with status {m.status}")


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
