
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="strawberries", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="chicken breasts", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="bowls of instant ramen", vtype=gurobi.GRB.INTEGER)

# Define the objective function
m.setObjective(4*x0 + 6*x1 + x2, gurobi.GRB.MAXIMIZE)

# Define the constraints
m.addConstr(6*x0 + 6*x2 >= 13, name="sourness_strawberries_ramen")
m.addConstr(8*x0 + 8*x1 >= 10, name="sourness_strawberries_chicken")
m.addConstr(3*x0 + 6*x1 >= 4, name="umami_strawberries_chicken")
m.addConstr(3*x0 + 7*x2 >= 6, name="umami_strawberries_ramen")
m.addConstr(3*x0 + 6*x1 + 7*x2 >= 11, name="umami_total")
m.addConstr(10*x1 - 3*x2 >= 0, name="chicken_ramen_constraint")
m.addConstr(8*x0 + 8*x1 <= 46, name="sourness_limit_strawberries_chicken")
m.addConstr(6*x0 + 6*x2 <= 44, name="sourness_limit_strawberries_ramen")
m.addConstr(6*x0 + 8*x1 + 6*x2 <= 44, name="sourness_limit_total")
m.addConstr(3*x0 + 7*x2 <= 17, name="umami_limit_strawberries_ramen")
m.addConstr(3*x0 + 6*x1 <= 22, name="umami_limit_strawberries_chicken")
m.addConstr(3*x0 + 6*x1 + 7*x2 <= 22, name="umami_limit_total")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Strawberries:", x0.varValue)
    print("Chicken breasts:", x1.varValue)
    print("Bowls of instant ramen:", x2.varValue)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found.")
