
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("calcium_optimization")

    # Create variables
    fruit_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fruit_salads")
    tomatoes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="tomatoes")
    kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
    oreos = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oreos")
    milkshakes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="milkshakes")

    # Set objective function
    m.setObjective(7*fruit_salads + 1*tomatoes + 4*kale_salads + 4*oreos + 9*milkshakes, gp.GRB.MINIMIZE)

    # Add constraints
    m.addConstr(tomatoes + kale_salads >= 14)
    m.addConstr(fruit_salads + tomatoes >= 30)
    m.addConstr(kale_salads + oreos >= 15)
    m.addConstr(kale_salads + milkshakes >= 26)
    m.addConstr(tomatoes + kale_salads + milkshakes >= 32)
    m.addConstr(tomatoes + kale_salads + oreos >= 32)
    m.addConstr(fruit_salads + kale_salads + milkshakes >= 32)
    m.addConstr(tomatoes + kale_salads + milkshakes >= 33)
    m.addConstr(tomatoes + kale_salads + oreos >= 33)
    m.addConstr(fruit_salads + kale_salads + milkshakes >= 33)
    m.addConstr(tomatoes + kale_salads + milkshakes >= 23)
    m.addConstr(tomatoes + kale_salads + oreos >= 23)
    m.addConstr(fruit_salads + kale_salads + milkshakes >= 23)
    m.addConstr(fruit_salads + tomatoes + kale_salads + oreos + milkshakes >= 23)
    m.addConstr(3*fruit_salads - 7*oreos >= 0)
    m.addConstr(fruit_salads + kale_salads <= 48)
    m.addConstr(tomatoes + oreos + milkshakes <= 105)
    m.addConstr(fruit_salads + tomatoes + kale_salads <= 55)
    m.addConstr(tomatoes + kale_salads + milkshakes <= 47)
    m.addConstr(4*fruit_salads + 1*tomatoes + 2*kale_salads + 7*oreos + 6*milkshakes <= 198)


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
