
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="fruit_salads", lb=0)
    x2 = model.addVar(name="tomatoes", lb=0)
    x3 = model.addVar(name="kale_salads", lb=0)
    x4 = model.addVar(name="oreos", lb=0)
    x5 = model.addVar(name="milkshakes", lb=0)

    # Objective function
    model.setObjective(7*x1 + 1*x2 + 4*x3 + 4*x4 + 9*x5, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(1*x2 + 2*x3 >= 14)
    model.addConstr(4*x1 + 1*x2 >= 30)
    model.addConstr(2*x3 + 7*x4 >= 15)
    model.addConstr(2*x3 + 6*x5 >= 26)
    model.addConstr(1*x2 + 2*x3 + 6*x5 >= 32)
    model.addConstr(1*x2 + 2*x3 + 7*x4 >= 32)
    model.addConstr(4*x1 + 2*x3 + 6*x5 >= 32)
    model.addConstr(1*x2 + 2*x3 + 6*x5 >= 33)
    model.addConstr(1*x2 + 2*x3 + 7*x4 >= 33)
    model.addConstr(4*x1 + 2*x3 + 6*x5 >= 33)
    model.addConstr(1*x2 + 2*x3 + 6*x5 >= 23)
    model.addConstr(1*x2 + 2*x3 + 7*x4 >= 23)
    model.addConstr(4*x1 + 2*x3 + 6*x5 >= 23)
    model.addConstr(4*x1 + 1*x2 + 2*x3 + 7*x4 + 6*x5 >= 23)
    model.addConstr(3*x1 - 7*x4 >= 0)
    model.addConstr(4*x1 + 2*x3 <= 48)
    model.addConstr(1*x2 + 7*x4 + 6*x5 <= 105)
    model.addConstr(4*x1 + 1*x2 + 2*x3 <= 55)
    model.addConstr(1*x2 + 2*x3 + 6*x5 <= 47)
    model.addConstr(4*x1 <= 198)
    model.addConstr(1*x2 <= 198)
    model.addConstr(2*x3 <= 198)
    model.addConstr(7*x4 <= 198)
    model.addConstr(6*x5 <= 198)
    model.addConstr(4*x1 + 1*x2 + 2*x3 + 7*x4 + 6*x5 <= 198)

    # Optimize the model
    model.optimize()

    # Print the status of the optimization
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print("Objective: ", model.objVal)
        print("Fruit Salads: ", x1.varValue)
        print("Tomatoes: ", x2.varValue)
        print("Kale Salads: ", x3.varValue)
        print("Oreos: ", x4.varValue)
        print("Milkshakes: ", x5.varValue)
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print("The model has a non-optimal status.")

solve_optimization_problem()
