
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("minimize_quit_likelihood")

    # Create variables
    laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")
    george_hours = model.addVar(vtype=GRB.INTEGER, name="george_hours")


    # Set objective function
    model.setObjective(8.0 * laura_hours + 1.14 * george_hours, GRB.MINIMIZE)

    # Add constraints
    model.addConstr(1 * laura_hours + 9 * george_hours >= 37, "c0")
    model.addConstr(1 * laura_hours + 9 * george_hours == 37, "c1")
    model.addConstr(-9 * laura_hours + 6 * george_hours >= 0, "c2")
    model.addConstr(1 * laura_hours + 9 * george_hours <= 79, "c3")


    # Optimize model
    model.optimize()

    # Check for infeasibility
    if model.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimal objective value: {model.objVal}")
        print(f"Laura's hours: {laura_hours.x}")
        print(f"George's hours: {george_hours.x}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
