
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Add variables
x1 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_George")

# Set the objective function
m.setObjective(8.0*x1 + 1.14*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(1*x1 + 9*x2 >= 37, "Combined_Likelihood_Lower_Bound")
m.addConstr(-9*x1 + 6*x2 >= 0, "Additional_Constraint")
m.addConstr(1*x1 + 9*x2 <= 79, "Combined_Likelihood_Upper_Bound")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Hours worked by Laura:", x1.x)
    print("Hours worked by George:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
