
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name='hours_worked_by_Laura', vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name='hours_worked_by_George', vtype=gurobi.GRB.INTEGER)

    # Objective function
    model.setObjective(8.0 * x1 + 1.14 * x2, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(x1 + 9 * x2 >= 37)
    model.addConstr(x1 + 9 * x2 <= 79)
    model.addConstr(-9 * x1 + 6 * x2 >= 0)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print('Optimal solution found.')
        print(f'Hours worked by Laura: {x1.varValue}')
        print(f'Hours worked by George: {x2.varValue}')
        print(f'Objective function value: {model.objVal}')
    else:
        print('No optimal solution found.')

solve_optimization_problem()
