
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    x0 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_A")
    x1 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="protein")
    x2 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="vitamin_C")
    x3 = m.addVar(vtype=gp.GRB.CONTINUOUS, name="magnesium")

    # Set objective function
    m.setObjective(1.69*x0 + 1.35*x1 + 3.26*x2 + 1.56*x3, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(2.53*x0 + 9.29*x2 >= 41, "c1")
    m.addConstr(9.29*x2 + 10.9*x3 <= 186, "c2")
    m.addConstr(2.53*x0 + 9.29*x2 <= 172, "c3")
    m.addConstr(1.03*x1 + 10.9*x3 <= 136, "c4")
    m.addConstr(2.53*x0 + 9.29*x2 + 10.9*x3 <= 119, "c5")
    m.addConstr(2.53*x0 + 1.03*x1 + 9.29*x2 <= 155, "c6")
    m.addConstr(1.03*x1 + 9.29*x2 + 10.9*x3 <= 52, "c7")
    m.addConstr(2.53*x0 + 1.03*x1 + 9.29*x2 + 10.9*x3 <= 52, "c8")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
