
import gurobi

def optimize_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="milligrams_of_vitamin_A", lb=0)
    x2 = model.addVar(name="grams_of_protein", lb=0)
    x3 = model.addVar(name="milligrams_of_vitamin_C", lb=0)
    x4 = model.addVar(name="milligrams_of_magnesium", lb=0)

    # Define the objective function
    model.setObjective(1.69*x1 + 1.35*x2 + 3.26*x3 + 1.56*x4, gurobi.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(2.53*x1 + 9.29*x3 >= 41)
    model.addConstr(9.29*x3 + 10.9*x4 <= 186)
    model.addConstr(2.53*x1 + 9.29*x3 <= 172)
    model.addConstr(1.03*x2 + 10.9*x4 <= 136)
    model.addConstr(2.53*x1 + 9.29*x3 + 10.9*x4 <= 119)
    model.addConstr(2.53*x1 + 1.03*x2 + 9.29*x3 <= 155)
    model.addConstr(1.03*x2 + 9.29*x3 + 10.9*x4 <= 52)
    model.addConstr(2.53*x1 + 1.03*x2 + 9.29*x3 + 10.9*x4 <= 52)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Milligrams of vitamin A: {x1.varValue}")
        print(f"Grams of protein: {x2.varValue}")
        print(f"Milligrams of vitamin C: {x3.varValue}")
        print(f"Milligrams of magnesium: {x4.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
