
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("vitamin_optimization")

    # Create variables
    x0 = model.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="x0") # milligrams of vitamin B6
    x1 = model.addVar(lb=0, vtype=gp.GRB.INTEGER, name="x1") # milligrams of vitamin A


    # Set objective function
    model.setObjective(5.62 * x0 + 8.21 * x1, gp.GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(23 * x0 + 10 * x1 >= 40, "c0")
    model.addConstr(26 * x0 + 23 * x1 >= 35, "c1")
    model.addConstr(12 * x0 + 21 * x1 >= 36, "c2")
    model.addConstr(11 * x0 + 18 * x1 >= 16, "c3")
    model.addConstr(17 * x0 + 16 * x1 >= 28, "c4")
    model.addConstr(-x0 + 10 * x1 >= 0, "c5")
    model.addConstr(23 * x0 + 10 * x1 <= 68, "c6")
    model.addConstr(26 * x0 + 23 * x1 <= 76, "c7")
    model.addConstr(12 * x0 + 21 * x1 <= 60, "c8")
    model.addConstr(11 * x0 + 18 * x1 <= 26, "c9")
    model.addConstr(17 * x0 + 16 * x1 <= 49, "c10")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        print('x0: %g' % x0.x)
        print('x1: %g' % x1.x)
    elif model.status == gp.GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
