
import gurobi

# Create a new model
model = gurobi.Model()

# Define variables
x1 = model.addVar(lb=0, name="milligrams_of_vitamin_B6")
x2 = model.addVar(lb=0, type=gurobi.GRB.INTEGER, name="milligrams_of_vitamin_A")

# Objective function
model.setObjective(5.62 * x1 + 8.21 * x2, gurobi.GRB.MAXIMIZE)

# Constraints
model.addConstr(23 * x1 <= 131, name="energy_stability_index_B6")
model.addConstr(26 * x1 <= 78, name="immune_support_index_B6")
model.addConstr(12 * x1 <= 86, name="muscle_growth_index_B6")
model.addConstr(11 * x1 <= 48, name="cognitive_performance_index_B6")
model.addConstr(17 * x1 <= 75, name="cardiovascular_support_index_B6")

model.addConstr(10 * x2 <= 131, name="energy_stability_index_A")
model.addConstr(23 * x2 <= 78, name="immune_support_index_A")
model.addConstr(21 * x2 <= 86, name="muscle_growth_index_A")
model.addConstr(18 * x2 <= 48, name="cognitive_performance_index_A")
model.addConstr(16 * x2 <= 75, name="cardiovascular_support_index_A")

model.addConstr(23 * x1 + 10 * x2 >= 40, name="combined_energy_stability_index")
model.addConstr(26 * x1 + 23 * x2 >= 35, name="combined_immune_support_index")
model.addConstr(12 * x1 + 21 * x2 >= 36, name="combined_muscle_growth_index")
model.addConstr(11 * x1 + 18 * x2 >= 16, name="combined_cognitive_performance_index")
model.addConstr(17 * x1 + 16 * x2 >= 28, name="combined_cardiovascular_support_index")

model.addConstr(-x1 + 10 * x2 >= 0, name="vitamin_A_B6_relation")

model.addConstr(23 * x1 + 10 * x2 <= 68, name="combined_energy_stability_index_upper")
model.addConstr(26 * x1 + 23 * x2 <= 76, name="combined_immune_support_index_upper")
model.addConstr(12 * x1 + 21 * x2 <= 60, name="combined_muscle_growth_index_upper")
model.addConstr(11 * x1 + 18 * x2 <= 26, name="combined_cognitive_performance_index_upper")
model.addConstr(17 * x1 + 16 * x2 <= 49, name="combined_cardiovascular_support_index_upper")

# Optimize
model.optimize()

# Print solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Milligrams of vitamin B6: {x1.varValue}")
    print(f"Milligrams of vitamin A: {x2.varValue}")
else:
    print("No optimal solution found.")
