
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="cherry pies")
x1 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="kale salads")
x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hot dogs")
x3 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="granola bars")
x4 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="sashimi")


# Set objective function
m.setObjective(8.47*x0**2 + 4.98*x0*x1 + 1.89*x0*x3 + 4.42*x0*x4 + 8.94*x1**2 + 3.13*x2**2 + 2.21*x2*x4 + 3.25*x3*x4 + 7.68*x1 + 5.23*x3, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x0 + 11*x3 + 15*x4 >= 38)
m.addConstr(14*x1 + 17*x3 >= 21)
m.addConstr(22*x2**2 + 21*x4**2 >= 23)
# ... (add all other constraints similarly)
m.addConstr(12 * x0 + 23 * x1 + 4 * x2 + 11 * x3 + 15 * x4 <= 240)
m.addConstr(1 * x0 + 14 * x1 + 22 * x2 + 17 * x3 + 21 * x4 <= 181)
m.addConstr(19 * x0 + 15 * x1 + 16 * x2 + 23 * x3 + 19 * x4 <= 336)
m.addConstr(10 * x0 + 15 * x1 + 6 * x2 + 4 * x3 + 10 * x4 <= 272)


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

