
import gurobi

# Create a new model
m = gurobi.Model()

# Define variables
x0 = m.addVar(name="milligrams_of_vitamin_K", vtype=gurobi.GRB.INTEGER)
x1 = m.addVar(name="milligrams_of_vitamin_B9", vtype=gurobi.GRB.INTEGER)
x2 = m.addVar(name="grams_of_carbohydrates", vtype=gurobi.GRB.INTEGER)
x3 = m.addVar(name="grams_of_fat")

# Objective function
m.setObjective(2.7*x0 + 7.93*x1 + 6.14*x2 + 1.38*x3, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(x0 <= 257)
m.addConstr(10*x0 + 30*x1 + 12*x2 + 23*x3 <= 198)
m.addConstr(x0 + 5*x1 + 5*x2 + 8*x3 >= 62)
m.addConstr(x0 + 5*x2 >= 51)
m.addConstr(x0 + 5*x1 + 8*x3 >= 54)
m.addConstr(x0 + 5*x1 + 5*x2 >= 54)
m.addConstr(x0 + 5*x2 + 8*x3 >= 54)
m.addConstr(x0 + 5*x1 + 8*x3 >= 42)
m.addConstr(x0 + 5*x1 + 5*x2 >= 42)
m.addConstr(x0 + 5*x2 + 8*x3 >= 42)
m.addConstr(x0 + 5*x1 + 8*x3 >= 40)
m.addConstr(x0 + 5*x1 + 5*x2 >= 40)
m.addConstr(x0 + 5*x2 + 8*x3 >= 40)
m.addConstr(12*x2 + 23*x3 >= 16)
m.addConstr(30*x1 + 23*x3 >= 19)
m.addConstr(30*x1 + 12*x2 + 23*x3 >= 41)
m.addConstr(10*x0 + 12*x2 + 23*x3 >= 41)
m.addConstr(30*x1 + 12*x2 + 23*x3 >= 42)
m.addConstr(10*x0 + 12*x2 + 23*x3 >= 42)
m.addConstr(5*x1 + 5*x2 <= 212)
m.addConstr(5*x2 + 8*x3 <= 117)
m.addConstr(x0 + 5*x1 <= 149)
m.addConstr(5*x1 + 8*x3 <= 230)
m.addConstr(x0 + 5*x1 + 8*x3 <= 155)
m.addConstr(x0 + 5*x1 + 5*x2 + 8*x3 <= 155)
m.addConstr(10*x0 + 23*x3 <= 195)
m.addConstr(10*x0 + 30*x1 <= 146)
m.addConstr(10*x0 + 12*x2 <= 136)
m.addConstr(30*x1 + 23*x3 <= 85)
m.addConstr(12*x2 + 23*x3 <= 164)
m.addConstr(10*x0 + 30*x1 + 12*x2 <= 115)
m.addConstr(10*x0 + 12*x2 + 23*x3 <= 156)
m.addConstr(10*x0 + 30*x1 + 12*x2 + 23*x3 <= 156)

# Optimize
m.optimize()

# Print solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("milligrams of vitamin K: ", x0.varValue)
    print("milligrams of vitamin B9: ", x1.varValue)
    print("grams of carbohydrates: ", x2.varValue)
    print("grams of fat: ", x3.varValue)
else:
    print("No solution found")
