
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="bowls_of_cereal")
    x1 = m.addVar(vtype=GRB.CONTINUOUS, name="granola_bars")

    # Set objective function
    m.setObjective(8.94*x0**2 + 9.03*x0*x1 + 6.24*x0 + 1.28*x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(15*x0 + 10*x1 >= 34, "cost_lower_bound")
    m.addConstr(12*x0 + 22*x1 >= 53, "iron_lower_bound")
    m.addConstr(15*x0 + 10*x1 <= 90, "cost_upper_bound")  # Corrected upper bound
    m.addConstr(12*x0 + 22*x1 <= 107, "iron_upper_bound") # Corrected upper bound
    m.addConstr(15*x0**2 + 10*x1**2 >= 34, "cost_squared_lower_bound")
    m.addConstr(12*x0**2 + 22*x1**2 >= 53, "iron_squared_lower_bound")
    m.addConstr(-9*x0 + 10*x1 >= 0, "linear_constraint")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        print('bowls_of_cereal:', x0.x)
        print('granola_bars:', x1.x)
    elif m.status == GRB.INFEASIBLE:
        print('The model is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
