
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="bowls_of_cereal", vtype=gurobi.GRB.INTEGER)  # integer variable for bowls of cereal
x2 = model.addVar(name="granola_bars")  # continuous variable for granola bars

# Objective function
model.setObjective(8.94 * x1**2 + 9.03 * x1 * x2 + 6.24 * x1 + 1.28 * x2, gurobi.GRB.MINIMIZE)

# Constraints
model.addConstr(15 * x1 <= 121, name="max_cost_bowls")  # assuming an upper bound for cost of bowls of cereal
model.addConstr(10 * x2 <= 113, name="max_cost_granola")  # assuming an upper bound for cost of granola bars
model.addConstr(15 * x1 + 10 * x2 >= 34, name="min_spend")
model.addConstr(x1**2 + x2**2 >= 34, name="min_spend_squared")
model.addConstr(12 * x1 + 22 * x2 >= 53, name="min_iron")
model.addConstr(12 * x1**2 + 22 * x2**2 >= 53, name="min_iron_squared")
model.addConstr(-9 * x1 + 10 * x2 >= 0, name="relationship")
model.addConstr(15 * x1 + 10 * x2 <= 90, name="max_spend")
model.addConstr(12 * x1 + 22 * x2 <= 107, name="max_iron")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", model.objval)
    print("Bowls of cereal: ", x1.varValue)
    print("Granola bars: ", x2.varValue)
else:
    print("The model is infeasible")
