
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Paul")
    x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="hours worked by Ringo")
    x2 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours worked by Bobby")


    # Set objective function
    m.setObjective(1.09*x0 + 1.75*x1 + 1.36*x2, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(8*x0 + 13*x2 >= 16, "c0")
    m.addConstr(8*x0 + 18*x1 >= 9, "c1")
    m.addConstr(8*x0 + 18*x1 + 13*x2 >= 9, "c2")
    m.addConstr(-8*x0 + 7*x2 >= 0, "c3")
    m.addConstr(-8*x0 + 4*x1 >= 0, "c4")
    m.addConstr(18*x1 + 13*x2 <= 32, "c5")
    m.addConstr(8*x0 + 13*x2 <= 52, "c6")


    # Optimize model
    m.optimize()

    # Print solution
    if m.status == GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == GRB.INFEASIBLE:
        print('The problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
