
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Paul")
x2 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="hours_worked_by_Ringo")
x3 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="hours_worked_by_Bobby")

# Set the objective function
m.setObjective(1.09*x1 + 1.75*x2 + 1.36*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x1 + 13*x3 >= 16, name="Paul_and_Bobby_min_score")
m.addConstr(8*x1 + 18*x2 >= 9, name="Paul_and_Ringo_min_score")
m.addConstr(8*x1 + 18*x2 + 13*x3 >= 9, name="All_min_score")
m.addConstr(-8*x1 + 7*x3 >= 0, name="Paul_and_Bobby_balance")
m.addConstr(-8*x1 + 4*x2 >= 0, name="Paul_and_Ringo_balance")
m.addConstr(18*x2 + 13*x3 <= 32, name="Ringo_and_Bobby_max_score")
m.addConstr(8*x1 + 13*x3 <= 52, name="Paul_and_Bobby_max_score")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    for var in m.getVars():
        print(f"{var.varName}: {var.x}")
else:
    print("No optimal solution found")
