
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="hours_worked_by_Paul", lb=0)  # No upper bound given, assuming continuous
    x2 = model.addVar(name="hours_worked_by_Ringo", lb=0, vtype=gurobi.GRB.INTEGER)  # Integer variable
    x3 = model.addVar(name="hours_worked_by_Bobby", lb=0)  # No upper bound given, assuming continuous

    # Objective function
    model.setObjective(1.09 * x1 + 1.75 * x2 + 1.36 * x3, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(8 * x1 + 13 * x3 >= 16)
    model.addConstr(8 * x1 + 18 * x2 >= 9)
    model.addConstr(8 * x1 + 18 * x2 + 13 * x3 >= 9)
    model.addConstr(-8 * x1 + 7 * x3 >= 0)
    model.addConstr(-8 * x1 + 4 * x2 >= 0)
    model.addConstr(18 * x2 + 13 * x3 <= 32)
    model.addConstr(8 * x1 + 13 * x3 <= 52)

    # Organization score constraints (Implicit in variable definition)
    # model.addConstr(x1 <= 69 / 8)  
    # model.addConstr(x2 <= 69 / 18)
    # model.addConstr(x3 <= 69 / 13)

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Paul: {x1.varValue}")
        print(f"Hours worked by Ringo: {x2.varValue}")
        print(f"Hours worked by Bobby: {x3.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
