
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="green_beans")
apples = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="apples")
kale_salads = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="kale_salads")
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")

# Set objective function
m.setObjective(2.61 * green_beans + 5.9 * apples + 4.48 * kale_salads + 2.81 * lemons, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(kale_salads + 2 * lemons >= 19)
m.addConstr(green_beans + 11 * kale_salads + 2 * lemons >= 27)
m.addConstr(green_beans + 10 * apples + 11 * kale_salads + 2 * lemons >= 27)
m.addConstr(4 * green_beans + 5 * kale_salads >= 11)
m.addConstr(4 * green_beans + 10 * apples >= 14)
m.addConstr(4 * green_beans + 9 * lemons >= 22)
m.addConstr(10 * apples + 5 * kale_salads >= 28)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads >= 23)
m.addConstr(10 * apples + 5 * kale_salads + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 10 * apples + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 5 * kale_salads + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads >= 21)
m.addConstr(10 * apples + 5 * kale_salads + 9 * lemons >= 21)
m.addConstr(4 * green_beans + 10 * apples + 9 * lemons >= 21)
m.addConstr(4 * green_beans + 5 * kale_salads + 9 * lemons >= 21)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads >= 20)
m.addConstr(10 * apples + 5 * kale_salads + 9 * lemons >= 20)
m.addConstr(4 * green_beans + 10 * apples + 9 * lemons >= 20)
m.addConstr(4 * green_beans + 5 * kale_salads + 9 * lemons >= 20)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads >= 23)
m.addConstr(10 * apples + 5 * kale_salads + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 10 * apples + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 5 * kale_salads + 9 * lemons >= 23)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads + 9 * lemons >= 23)
m.addConstr(-apples + lemons >= 0)
m.addConstr(-3 * kale_salads + 9 * lemons >= 0)
m.addConstr(-9 * green_beans + 9 * lemons >= 0)
m.addConstr(green_beans + 10 * apples <= 85)
m.addConstr(10 * apples + 11 * kale_salads <= 59)
m.addConstr(10 * apples + 2 * lemons <= 98)
m.addConstr(4 * green_beans + 10 * apples <= 101)
m.addConstr(10 * apples + 5 * kale_salads <= 99)
m.addConstr(green_beans + 10 * apples + 11 * kale_salads + 2 * lemons <= 109)
m.addConstr(4 * green_beans + 10 * apples + 5 * kale_salads + 9 * lemons <= 120)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

