
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="green_beans", lb=0)
    x1 = model.addVar(name="apples", lb=0)
    x2 = model.addVar(name="kale_salads", lb=0)
    x3 = model.addVar(name="lemons", lb=0)

    # Define the objective function
    model.setObjective(2.61 * x0 + 5.9 * x1 + 4.48 * x2 + 2.81 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(11 * x2 + 2 * x3 >= 19)
    model.addConstr(x0 + 10 * x1 + 11 * x2 + 2 * x3 >= 27)
    model.addConstr(4 * x0 + 10 * x1 >= 14)
    model.addConstr(4 * x0 + 5 * x2 >= 11)
    model.addConstr(4 * x0 + 9 * x3 >= 22)
    model.addConstr(10 * x1 + 5 * x2 >= 28)
    model.addConstr(4 * x0 + 10 * x1 + 5 * x2 >= 23)
    model.addConstr(10 * x1 + 5 * x2 + 9 * x3 >= 23)
    model.addConstr(4 * x0 + 10 * x1 + 9 * x3 >= 23)
    model.addConstr(4 * x0 + 5 * x2 + 9 * x3 >= 23)
    model.addConstr(-x1 + x3 >= 0)
    model.addConstr(-3 * x2 + 9 * x3 >= 0)
    model.addConstr(-9 * x0 + 9 * x3 >= 0)
    model.addConstr(x0 + 10 * x1 <= 85)
    model.addConstr(10 * x1 + 11 * x2 <= 59)
    model.addConstr(10 * x1 + 2 * x3 <= 98)
    model.addConstr(4 * x0 + 10 * x1 <= 101)
    model.addConstr(10 * x1 + 5 * x2 <= 99)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Green beans: {x0.varValue}")
        print(f"Apples: {x1.varValue}")
        print(f"Kale salads: {x2.varValue}")
        print(f"Lemons: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
