
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(vtype=GRB.INTEGER, name="packs of paper plates")
    x1 = m.addVar(vtype=GRB.INTEGER, name="cartons of milk")


    # Set objective function
    m.setObjective(1.68 * x0 + 9.87 * x1, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(16.51 * x0 + 6.66 * x1 >= 35, "usefulness_lower_bound")
    m.addConstr(13.09 * x0 + 14.76 * x1 >= 34, "portability_lower_bound")
    m.addConstr(-8 * x0 + 3 * x1 >= 0, "constraint_3")
    m.addConstr(16.51 * x0 + 6.66 * x1 <= 71, "usefulness_upper_bound")
    m.addConstr(13.09 * x0 + 14.76 * x1 <= 42, "portability_upper_bound")


    # Optimize model
    m.optimize()

    # Check for infeasibility
    if m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        # Print optimal solution
        print("Optimal objective value:", m.objVal)
        print("Packs of paper plates:", x0.x)
        print("Cartons of milk:", x1.x)


except gp.GrorbiError as e:
    print(f"Gurobi error: {e}")

except AttributeError:
    print("Encountered an attribute error. Check if the model optimized successfully.")

