
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="packs_of_paper_plates")
x2 = m.addVar(vtype=GRB.INTEGER, name="cartons_of_milk")

# Set objective function
m.setObjective(1.68*x1 + 9.87*x2, GRB.MINIMIZE)

# Add constraints
m.addConstr(16.51*x1 + 6.66*x2 >= 35, "usefulness_rating_min")
m.addConstr(13.09*x1 + 14.76*x2 >= 34, "portability_rating_min")
m.addConstr(-8*x1 + 3*x2 >= 0, "additional_constraint")
m.addConstr(16.51*x1 + 6.66*x2 <= 71, "usefulness_rating_max")
m.addConstr(13.09*x1 + 14.76*x2 <= 42, "portability_rating_max")

# Optimize the model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Packs of paper plates:", x1.x)
    print("Cartons of milk:", x2.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
