
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="packs_of_paper_plates", vtype=gurobi.GRB.INTEGER)
    x2 = model.addVar(name="cartons_of_milk", vtype=gurobi.GRB.INTEGER)

    # Define the objective function
    model.setObjective(1.68 * x1 + 9.87 * x2, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(16.51 * x1 + 6.66 * x2 >= 35, name="usefulness_rating")
    model.addConstr(13.09 * x1 + 14.76 * x2 >= 34, name="portability_rating")
    model.addConstr(-8 * x1 + 3 * x2 >= 0, name="milk_vs_plates")
    model.addConstr(16.51 * x1 + 6.66 * x2 <= 102, name="max_usefulness")
    model.addConstr(13.09 * x1 + 14.76 * x2 <= 42, name="max_portability")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("packs of paper plates: ", x1.varValue)
        print("cartons of milk: ", x2.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
