
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x0 = model.addVar(vtype=GRB.INTEGER, name="x0") # hours worked by Ringo
    x1 = model.addVar(vtype=GRB.INTEGER, name="x1") # hours worked by Jean
    x2 = model.addVar(vtype=GRB.CONTINUOUS, name="x2") # hours worked by George


    # Set objective function
    model.setObjective(1*x0**2 + 4*x0*x1 + 2*x0*x2 + 6*x1**2 + 1*x1*x2 + 9*x2**2 + 4*x0 + 7*x1 + 4*x2, GRB.MAXIMIZE)

    # Add constraints
    model.addConstr(5*x0 + 2*x1 >= 24, "c0")
    model.addConstr(5*x0**2 + 7*x2**2 >= 42, "c1")
    model.addConstr(2*x1**2 + 7*x2**2 >= 38, "c2")
    model.addConstr(6*x0**2 + 9*x1**2 + 1*x2**2 >= 19, "c3")
    model.addConstr(5*x0**2 + 2*x1**2 <= 42, "c4")
    model.addConstr(2*x1**2 + 7*x2**2 <= 124, "c5")
    model.addConstr(5*x0 + 2*x1 + 7*x2 <= 124, "c6")
    model.addConstr(9*x1 + 1*x2 <= 47, "c7")
    model.addConstr(6*x0**2 + 1*x2**2 <= 93, "c8")
    model.addConstr(6*x0 + 9*x1 <= 33, "c9")
    model.addConstr(6*x0**2 + 9*x1**2 + 1*x2**2 <= 84, "c10")
    model.addConstr(6*x0 + 9*x1 + 1*x2 <= 84, "c11")


    # Optimize model
    model.optimize()

    if model.status == GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == GRB.INFEASIBLE:
        print('Model is infeasible')


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
