
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", integer=True)  # hours worked by Ringo
x1 = m.addVar(name="x1", integer=True)  # hours worked by Jean
x2 = m.addVar(name="x2")  # hours worked by George

# Objective function
m.setObjective(1*x0**2 + 4*x0*x1 + 2*x0*x2 + 6*x1**2 + 1*x1*x2 + 9*x2**2 + 4*x0 + 7*x1 + 4*x2, gurobi.GRB.MAXIMIZE)

# Constraints
m.addConstr(5*x0 == 5, name="Ringo_computer")
m.addConstr(6*x0 == 6, name="Ringo_cost")
m.addConstr(2*x1 == 2, name="Jean_computer")
m.addConstr(9*x1 == 9, name="Jean_cost")
m.addConstr(7*x2 == 7, name="George_computer")
m.addConstr(1*x2 == 1, name="George_cost")

m.addConstr(5*x0 + 2*x1 >= 24, name="min_computer_rating_Ringo_Jean")
m.addConstr(25*x0**2 + 49*x2**2 >= 42, name="min_computer_rating_Ringo_George")
m.addConstr(4*x1**2 + 49*x2**2 >= 38, name="min_computer_rating_Jean_George")
m.addConstr(36*x0**2 + 81*x1**2 + x2**2 >= 19, name="min_dollar_cost")
m.addConstr(25*x0**2 + 4*x1**2 <= 42, name="max_computer_rating_Ringo_Jean")
m.addConstr(4*x1**2 + 49*x2**2 <= 124, name="max_computer_rating_Jean_George")
m.addConstr(5*x0 + 2*x1 + 7*x2 <= 124, name="max_total_computer_rating")
m.addConstr(9*x1 + x2 <= 47, name="max_dollar_cost_Jean_George")
m.addConstr(36*x0**2 + x2**2 <= 93, name="max_dollar_cost_Ringo_George")
m.addConstr(6*x0 + 9*x1 <= 33, name="max_dollar_cost_Ringo_Jean")
m.addConstr(36*x0**2 + 81*x1**2 + x2**2 <= 84, name="max_dollar_cost_all")
m.addConstr(6*x0 + 9*x1 + x2 <= 84, name="max_total_dollar_cost")

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
else:
    print("The model is infeasible")
