
import gurobipy as gp

try:
    # Create a new model
    model = gp.Model("optimization_problem")

    # Create variables
    x = model.addVars(4, lb=0, vtype=gp.GRB.CONTINUOUS, name=["Ringo", "Bobby", "Mary", "Jean"])


    # Set objective function
    model.setObjective(6*x[0] + 7*x[1] + 9*x[2] + 1*x[3], gp.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10*x[0] + 7*x[3] >= 33, "c0")
    model.addConstr(11*x[2] + 7*x[3] >= 36, "c1")
    model.addConstr(3*x[1] + 11*x[2] >= 40, "c2")
    model.addConstr(3*x[1] + 7*x[3] >= 54, "c3")
    model.addConstr(10*x[0] + 11*x[2] >= 35, "c4")
    model.addConstr(10*x[0] + 3*x[1] + 11*x[2] + 7*x[3] >= 35, "c5")
    model.addConstr(5*x[1] + 7*x[3] >= 23, "c6")
    model.addConstr(4*x[0] + 5*x[1] >= 11, "c7")
    model.addConstr(5*x[1] + 5*x[2] >= 10, "c8")
    model.addConstr(4*x[0] + 5*x[2] >= 14, "c9")
    model.addConstr(5*x[1] + 5*x[2] + 7*x[3] >= 16, "c10")
    model.addConstr(4*x[0] + 5*x[1] + 5*x[2] + 7*x[3] >= 16, "c11")
    model.addConstr(9*x[0] + 3*x[1] >= 20, "c12")
    model.addConstr(9*x[0] + 1*x[2] >= 36, "c13")
    model.addConstr(1*x[2] + 10*x[3] >= 39, "c14")
    model.addConstr(9*x[0] + 3*x[1] + 1*x[2] + 10*x[3] >= 39, "c15")
    model.addConstr(10*x[0] + 3*x[1] <= 218, "c16")
    model.addConstr(5*x[2] + 7*x[3] <= 88, "c17")
    model.addConstr(9*x[0] + 1*x[2] + 10*x[3] <= 138, "c18")


    # Optimize model
    model.optimize()

    if model.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % model.objVal)
        for v in model.getVars():
            print('%s %g' % (v.varName, v.x))
    elif model.status == gp.GRB.INFEASIBLE:
        print('Model is infeasible')
    else:
        print('Model status is:', model.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
