
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x0 = model.addVar(name="x0", lb=0)  # hours worked by Ringo
    x1 = model.addVar(name="x1", lb=0)  # hours worked by Bobby
    x2 = model.addVar(name="x2", lb=0)  # hours worked by Mary
    x3 = model.addVar(name="x3", lb=0)  # hours worked by Jean

    # Define the objective function
    model.setObjective(6 * x0 + 7 * x1 + 9 * x2 + 1 * x3, gurobi.GRB.MINIMIZE)

    # Add constraints
    model.addConstr(10 * x0 <= 260)
    model.addConstr(4 * x0 <= 94)
    model.addConstr(9 * x0 <= 216)
    model.addConstr(3 * x1 <= 260)
    model.addConstr(5 * x1 <= 94)
    model.addConstr(3 * x1 <= 216)
    model.addConstr(11 * x2 <= 260)
    model.addConstr(5 * x2 <= 94)
    model.addConstr(1 * x2 <= 216)
    model.addConstr(7 * x3 <= 260)
    model.addConstr(7 * x3 <= 94)
    model.addConstr(10 * x3 <= 216)
    model.addConstr(10 * x0 + 7 * x3 >= 33)
    model.addConstr(11 * x2 + 7 * x3 >= 36)
    model.addConstr(3 * x1 + 11 * x2 >= 40)
    model.addConstr(3 * x1 + 7 * x3 >= 54)
    model.addConstr(10 * x0 + 11 * x2 >= 35)
    model.addConstr(10 * x0 + 3 * x1 + 11 * x2 + 7 * x3 >= 35)
    model.addConstr(5 * x1 + 7 * x3 >= 23)
    model.addConstr(4 * x0 + 5 * x1 >= 11)
    model.addConstr(5 * x1 + 5 * x2 >= 10)
    model.addConstr(4 * x0 + 5 * x2 >= 14)
    model.addConstr(5 * x1 + 5 * x2 + 7 * x3 >= 16)
    model.addConstr(4 * x0 + 5 * x1 + 5 * x2 + 7 * x3 >= 16)
    model.addConstr(9 * x0 + 3 * x1 >= 20)
    model.addConstr(9 * x0 + 1 * x2 >= 36)
    model.addConstr(1 * x2 + 10 * x3 >= 39)
    model.addConstr(9 * x0 + 3 * x1 + 1 * x2 + 10 * x3 >= 39)
    model.addConstr(10 * x0 + 3 * x1 <= 218)
    model.addConstr(5 * x2 + 7 * x3 <= 88)
    model.addConstr(9 * x0 + 1 * x2 + 10 * x3 <= 138)

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objval)
        print("x0: ", x0.varValue)
        print("x1: ", x1.varValue)
        print("x2: ", x2.varValue)
        print("x3: ", x3.varValue)
    else:
        print("The model is infeasible")

solve_optimization_problem()
