
import gurobipy as gp

# Create a new model
model = gp.Model("optimization_problem")

# Create variables
peggy = model.addVar(vtype=gp.GRB.INTEGER, name="peggy")
laura = model.addVar(vtype=gp.GRB.CONTINUOUS, name="laura")
hank = model.addVar(vtype=gp.GRB.INTEGER, name="hank")
bobby = model.addVar(vtype=gp.GRB.CONTINUOUS, name="bobby")


# Set objective function
model.setObjective(9.01 * peggy + 4.3 * laura + 5.2 * hank + 7.19 * bobby, gp.GRB.MINIMIZE)

# Add constraints
model.addConstr(7 * laura + 8 * bobby >= 13)
model.addConstr(7 * hank + 8 * bobby >= 13)
model.addConstr(7 * peggy + 7 * hank >= 6)
model.addConstr(7 * peggy + 8 * bobby >= 11)
model.addConstr(2 * laura + 7 * hank + 8 * bobby >= 11)
model.addConstr(7 * peggy + 2 * laura + 7 * hank >= 11)
model.addConstr(2 * laura + 7 * hank + 8 * bobby >= 8)
model.addConstr(7 * peggy + 2 * laura + 7 * hank >= 8)
model.addConstr(7 * peggy + 2 * laura + 7 * hank + 8 * bobby >= 8)
model.addConstr(1 * peggy + 3 * hank >= 15)
model.addConstr(1 * peggy + 1 * laura >= 14)
model.addConstr(1 * peggy + 3 * hank + 1 * bobby >= 21)
model.addConstr(1 * peggy + 1 * laura + 3 * hank >= 21)
model.addConstr(1 * peggy + 3 * hank + 1 * bobby >= 10)
model.addConstr(1 * peggy + 1 * laura + 3 * hank >= 10)
model.addConstr(1 * peggy + 1 * laura + 3 * hank + 1 * bobby >= 10)
model.addConstr(10 * laura - 2 * bobby >= 0)
model.addConstr(-6 * peggy + 9 * laura >= 0)
model.addConstr(2 * laura + 7 * hank <= 24)
model.addConstr(7 * peggy + 2 * laura <= 52)
model.addConstr(2 * laura + 8 * bobby <= 34)
model.addConstr(1 * peggy + 3 * hank + 1 * bobby <= 68)



# Optimize model
model.optimize()

# Print results
if model.status == gp.GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Peggy: {peggy.x}")
    print(f"Laura: {laura.x}")
    print(f"Hank: {hank.x}")
    print(f"Bobby: {bobby.x}")
    print(f"Objective value: {model.objVal}")
elif model.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {model.status}")

