
import gurobi

# Create a new model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name="x0", lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Peggy
x1 = m.addVar(name="x1", lb=0)  # hours worked by Laura
x2 = m.addVar(name="x2", lb=0, type=gurobi.GRB.INTEGER)  # hours worked by Hank
x3 = m.addVar(name="x3", lb=0)  # hours worked by Bobby

# Objective function
m.setObjective(9.01 * x0 + 4.3 * x1 + 5.2 * x2 + 7.19 * x3, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(7 * x0 <= 61)
m.addConstr(1 * x0 <= 86)
m.addConstr(2 * x1 <= 61)
m.addConstr(1 * x1 <= 86)
m.addConstr(7 * x2 <= 61)
m.addConstr(3 * x2 <= 86)
m.addConstr(8 * x3 <= 61)
m.addConstr(1 * x3 <= 86)
m.addConstr(2 * x1 + 8 * x3 >= 13)
m.addConstr(7 * x2 + 8 * x3 >= 13)
m.addConstr(7 * x0 + 7 * x2 >= 6)
m.addConstr(7 * x0 + 8 * x3 >= 11)
m.addConstr(2 * x1 + 7 * x2 + 8 * x3 >= 11)
m.addConstr(7 * x0 + 2 * x1 + 7 * x2 >= 11)
m.addConstr(2 * x1 + 7 * x2 + 8 * x3 >= 8)
m.addConstr(7 * x0 + 2 * x1 + 7 * x2 >= 8)
m.addConstr(7 * x0 + 2 * x1 + 7 * x2 + 8 * x3 >= 8)
m.addConstr(x0 + 3 * x2 >= 15)
m.addConstr(x0 + x1 >= 14)
m.addConstr(x0 + 3 * x2 + x3 >= 21)
m.addConstr(x0 + x1 + 3 * x2 >= 21)
m.addConstr(x0 + 3 * x2 + x3 >= 10)
m.addConstr(x0 + x1 + 3 * x2 >= 10)
m.addConstr(x0 + x1 + 3 * x2 + x3 >= 10)
m.addConstr(10 * x1 - 2 * x3 >= 0)
m.addConstr(-6 * x0 + 9 * x1 >= 0)
m.addConstr(2 * x1 + 7 * x2 <= 24)
m.addConstr(7 * x0 + 2 * x1 <= 52)
m.addConstr(2 * x1 + 8 * x3 <= 34)
m.addConstr(x0 + 3 * x2 + x3 <= 68)

# Solve the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("x0: ", x0.varValue)
    print("x1: ", x1.varValue)
    print("x2: ", x2.varValue)
    print("x3: ", x3.varValue)
else:
    print("The model is infeasible")
