
from gurobipy import *

# Create a new model
m = Model("Work Hours Optimization")

# Define variables
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
x2 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Paul")
x3 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Jean")
x4 = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Mary")
x5 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")

# Objective function: Maximize total productivity
m.setObjective(14*x1 + 10*x3 + 6*x4 + 12*x5 + 8*x2, GRB.MAXIMIZE)

# Add constraints
# Example constraint: Total combined computer competence rating from Dale and Paul should be greater than or equal to 44
m.addConstr(14*x1 + 8*x2 >= 44, "computer_competence_Dale_Paul")

# Integrate all other constraints here following the problem description

m.optimize()
