
import gurobi

# Create a new Gurobi model
m = gurobi.Model()

# Define the variables
x0 = m.addVar(name='x0', lb=0, ub=None)  # hours worked by Dale
x1 = m.addVar(name='x1', lb=0, ub=None, integrality=1)  # hours worked by Paul
x2 = m.addVar(name='x2', lb=0, ub=None)  # hours worked by Jean
x3 = m.addVar(name='x3', lb=0, ub=None, integrality=1)  # hours worked by Mary
x4 = m.addVar(name='x4', lb=0, ub=None)  # hours worked by Hank

# Define the objective function
m.setObjective(9*x0*x1 + 8*x0*x2 + 3*x0*x3 + 9*x1*x3 + 3*x1*x4 + 2*x2*x4 + 2*x3*x4 + 7*x4**2 + 7*x3 + 8*x4, gurobi.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14*x0 >= 14)
m.addConstr(2*x0 >= 2)
m.addConstr(14*x0 >= 14)
m.addConstr(13*x1 >= 13)
m.addConstr(x1 >= 1)
m.addConstr(4*x1 >= 4)
m.addConstr(8*x2 >= 8)
m.addConstr(7*x2 >= 7)
m.addConstr(15*x2 >= 15)
m.addConstr(3*x3 >= 3)
m.addConstr(17*x3 >= 17)
m.addConstr(5*x3 >= 5)
m.addConstr(12*x4 >= 12)
m.addConstr(6*x4 >= 6)
m.addConstr(11*x4 >= 11)
m.addConstr(14*x0 + 12*x4 >= 58)
m.addConstr(3*x3 + 12*x4 >= 93)
m.addConstr(13*x1 + 8*x2 >= 40)
m.addConstr(8*x2 + 3*x3 + 12*x4 >= 88)
m.addConstr(14*x0 + 13*x1 + 8*x2 >= 88)
m.addConstr(196*x0**2 + 169*x1**2 + 9*x3**2 >= 88)
m.addConstr(13*x1 + 8*x2 + 3*x3 >= 88)
m.addConstr(196*x0**2 + 64*x2**2 + 144*x4**2 >= 88)
m.addConstr(64*x2**2 + 9*x3**2 + 144*x4**2 >= 82)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', m.objVal)
    print('x0: ', x0.varValue)
    print('x1: ', x1.varValue)
    print('x2: ', x2.varValue)
    print('x3: ', x3.varValue)
    print('x4: ', x4.varValue)
else:
    print('No solution found')
