
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, name="black_beans")
x1 = m.addVar(lb=0, name="protein_bars")
x2 = m.addVar(lb=0, name="cantaloupes")
x3 = m.addVar(lb=0, name="potatoes")
x4 = m.addVar(lb=0, name="chicken_thighs")


# Set objective function
m.setObjective(4.02*x0**2 + 1.5*x0*x1 + 2.97*x0*x3 + 9.14*x1**2 + 6.05*x1*x3 + 3.4*x2**2 + 8.07*x2*x4 + 2.66*x3*x4 + 2.08*x4**2 + 8.24*x0 + 7.75*x2 + 7.02*x3, GRB.MINIMIZE)

# Add constraints
m.addConstr(22*x0 + 4*x1 + 10*x2 + 9*x3 + 4*x4 <= 509, "budget")
m.addConstr(10*x2 + 4*x4 >= 66, "cantaloupe_chicken_min")
m.addConstr(22*x0 + 4*x1 + 10*x2 + 9*x3 + 4*x4 >= 66, "total_spend_min")
m.addConstr(-9*x0**2 + 6*x4**2 >= 0, "beans_chicken_ratio")
m.addConstr(10*x2 - 9*x4 >= 0, "cantaloupe_chicken_ratio")
m.addConstr(7*x0 - 4*x1 >= 0, "beans_protein_ratio")
m.addConstr(22**2*x0**2 + 4**2*x1**2 <= 348, "beans_protein_spend_max") # corrected constraint
m.addConstr(22*x0 + 9*x3 + 4*x4 <= 459, "beans_potatoes_chicken_max")
m.addConstr(22*x0 + 10*x2 + 9*x3 <= 285, "beans_cantaloupe_potatoes_max")
m.addConstr(4*x1 + 10*x2 + 4*x4 <= 150, "protein_cantaloupe_chicken_max")
m.addConstr(10*x2 + 9*x3 + 4*x4 <= 265, "cantaloupe_potatoes_chicken_max")
m.addConstr(22*x0 + 4*x1 + 4*x4 <= 382, "beans_protein_chicken_max")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == GRB.INFEASIBLE:
    print('Optimization problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

