
import gurobi

# Define the model
m = gurobi.Model()

# Define the variables
x1 = m.addVar(name="black_beans", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = m.addVar(name="protein_bars", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x3 = m.addVar(name="cantaloupes", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x4 = m.addVar(name="potatoes", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x5 = m.addVar(name="chicken_thighs", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Objective function
m.setObjective(4.02*x1**2 + 1.5*x1*x2 + 2.97*x1*x4 + 9.14*x2**2 + 6.05*x2*x4 + 3.4*x3**2 + 8.07*x3*x5 + 2.66*x4*x5 + 2.08*x5**2 + 8.24*x1 + 7.75*x3 + 7.02*x4, gurobi.GRB.MINIMIZE)

# Constraints
m.addConstr(22*x1 + 4*x2 + 10*x3 + 9*x4 + 4*x5 >= 66)
m.addConstr(-9*x1**2 + 6*x5**2 >= 0)
m.addConstr(10*x3 - 9*x5 >= 0)
m.addConstr(7*x1 - 4*x2 >= 0)
m.addConstr(22**2*x1**2 + 4**2*x2**2 <= 348)
m.addConstr(22*x1 + 9*x4 + 4*x5 <= 459)
m.addConstr(22*x1 + 10*x3 + 9*x4 <= 285)
m.addConstr(4*x2 + 10*x3 + 4*x5 <= 150)
m.addConstr(10*x3 + 9*x4 + 4*x5 <= 265)
m.addConstr(22*x1 + 4*x2 + 4*x5 <= 382)

# Optimize the model
m.optimize()

# Print the solution
if m.status == gurobi.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Black beans: ", x1.varValue)
    print("Protein bars: ", x2.varValue)
    print("Cantaloupes: ", x3.varValue)
    print("Potatoes: ", x4.varValue)
    print("Chicken thighs: ", x5.varValue)
else:
    print("The model is infeasible")
