
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
green_beans = m.addVar(vtype=GRB.INTEGER, name="green_beans")
bowls_of_cereal = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")


# Set objective function
m.setObjective(6 * green_beans + 6 * bowls_of_cereal, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12 * green_beans + 3 * bowls_of_cereal >= 31, "healthiness_min")
m.addConstr(14 * green_beans + 10 * bowls_of_cereal >= 16, "calcium_min")
m.addConstr(10 * green_beans + 6 * bowls_of_cereal >= 13, "carbohydrates_min")
m.addConstr(-2 * green_beans + 9 * bowls_of_cereal >= 0, "constraint4")
m.addConstr(12 * green_beans + 3 * bowls_of_cereal <= 65, "healthiness_max")
m.addConstr(14 * green_beans + 10 * bowls_of_cereal <= 35, "calcium_max")
m.addConstr(10 * green_beans + 6 * bowls_of_cereal <= 36, "carbohydrates_max")



# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('green_beans:', green_beans.x)
    print('bowls_of_cereal:', bowls_of_cereal.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)

