
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x1 = m.addVar(vtype=GRB.INTEGER, name="green_beans")
x2 = m.addVar(vtype=GRB.CONTINUOUS, name="bowls_of_cereal")

# Set the objective function
m.setObjective(6*x1 + 6*x2, GRB.MAXIMIZE)

# Add constraints
m.addConstr(12*x1 + 3*x2 >= 31, "healthiness_rating_min")
m.addConstr(14*x1 + 10*x2 >= 16, "calcium_min")
m.addConstr(10*x1 + 6*x2 >= 13, "carbohydrates_min")
m.addConstr(-2*x1 + 9*x2 >= 0, "mixed_constraint")
m.addConstr(12*x1 + 3*x2 <= 65, "healthiness_rating_max")
m.addConstr(14*x1 + 10*x2 <= 35, "calcium_max")
m.addConstr(10*x1 + 6*x2 <= 36, "carbohydrates_max")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print("Objective:", m.objVal)
