
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x1 = model.addVar(name="green_beans", vtype=gurobi.GRB.INTEGER)  # Green beans
    x2 = model.addVar(name="bowls_of_cereal")  # Bowls of cereal

    # Objective function: Maximize 6*x1 + 6*x2
    model.setObjective(6*x1 + 6*x2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(12*x1 + 3*x2 >= 31)  # Healthiness rating min
    model.addConstr(14*x1 + 10*x2 >= 16)  # Milligrams of calcium min
    model.addConstr(10*x1 + 6*x2 >= 13)  # Grams of carbohydrates min
    model.addConstr(-2*x1 + 9*x2 >= 0)  # Specific linear constraint
    model.addConstr(12*x1 + 3*x2 <= 65)  # Healthiness rating max
    model.addConstr(14*x1 + 10*x2 <= 35)  # Milligrams of calcium max
    model.addConstr(10*x1 + 6*x2 <= 36)  # Grams of carbohydrates max

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Green beans: {x1.varValue}")
        print(f"Bowls of cereal: {x2.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
