
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cheeseburgers = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
rotisserie_chickens = m.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Set objective function
m.setObjective(6 * cheeseburgers + 3 * rotisserie_chickens, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * cheeseburgers + 4 * rotisserie_chickens >= 10, "c1: umami_min")
m.addConstr(6 * cheeseburgers + 5 * rotisserie_chickens >= 18, "c2: cost_min")
m.addConstr(4 * cheeseburgers + 9 * rotisserie_chickens >= 56, "c3: protein_min")
m.addConstr(1 * cheeseburgers - 3 * rotisserie_chickens >= 0, "c4: cheeseburger_chicken_ratio")
m.addConstr(6 * cheeseburgers + 4 * rotisserie_chickens <= 20, "c5: umami_max")
m.addConstr(6 * cheeseburgers + 5 * rotisserie_chickens <= 43, "c6: cost_max")
m.addConstr(4 * cheeseburgers + 9 * rotisserie_chickens <= 89, "c7: protein_max")


# Optimize model
m.optimize()

# Check for infeasibility
if m.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print optimal solution
    print("Optimal Solution:")
    print(f"Cheeseburgers: {cheeseburgers.x}")
    print(f"Rotisserie Chickens: {rotisserie_chickens.x}")
    print(f"Objective Value: {m.objVal}")

