
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.INTEGER, name="cheeseburgers")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="rotisserie_chickens")

# Set objective function
m.setObjective(6*x0 + 3*x1, GRB.MAXIMIZE)

# Add constraints
m.addConstr(6*x0 + 4*x1 >= 10, "umami_index_min")
m.addConstr(6*x0 + 5*x1 >= 18, "dollar_cost_min")
m.addConstr(4*x0 + 9*x1 >= 56, "protein_grams_min")
m.addConstr(x0 - 3*x1 >= 0, "special_constraint")
m.addConstr(6*x0 + 4*x1 <= 20, "umami_index_max")
m.addConstr(6*x0 + 5*x1 <= 43, "dollar_cost_max")
m.addConstr(4*x0 + 9*x1 <= 89, "protein_grams_max")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Cheeseburgers: {x0.x}")
    print(f"Rotisserie chickens: {x1.x}")
    print(f"Objective value: {m.objVal}")
else:
    print("No optimal solution found.")
