
import gurobi

# Create a new model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name='cheeseburgers', vtype=gurobi.GRB.INTEGER)  # integer variable for cheeseburgers
x2 = model.addVar(name='rotisserie_chickens')  # continuous variable for rotisserie chickens

# Define the objective function
model.setObjective(6 * x1 + 3 * x2, gurobi.GRB.MAXIMIZE)

# Add constraints
model.addConstr(6 * x1 + 4 * x2 >= 10, name='umami_min')
model.addConstr(6 * x1 + 5 * x2 >= 18, name='cost_min')
model.addConstr(4 * x1 + 9 * x2 >= 56, name='protein_min')
model.addConstr(x1 - 3 * x2 >= 0, name='cheeseburgers_vs_chickens')
model.addConstr(6 * x1 + 4 * x2 <= 20, name='umami_max')
model.addConstr(6 * x1 + 5 * x2 <= 43, name='cost_max')
model.addConstr(4 * x1 + 9 * x2 <= 89, name='protein_max')

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print('Objective: ', model.objval)
    print('Cheeseburgers: ', x1.varValue)
    print('Rotisserie Chickens: ', x2.varValue)
else:
    print('The model is infeasible')
