
import gurobipy as gp

try:
    # Create a new model
    m = gp.Model("optimization_problem")

    # Create variables
    x0 = m.addVar(name="hours worked by Hank")
    x1 = m.addVar(name="hours worked by Jean")


    # Set objective function
    m.setObjective(5*x0 + 1*x1, gp.GRB.MAXIMIZE)

    # Add constraints
    m.addConstr(3.54*x0 + 5.02*x1 >= 57, "c1")
    m.addConstr(3.9*x0 + 1.19*x1 >= 29, "c2")
    m.addConstr(6.25*x0 + 9.25*x1 >= 63, "c3")
    m.addConstr(3.72*x0 + 4.65*x1 >= 61, "c4")
    m.addConstr(-6*x0 + 1*x1 >= 0, "c5")
    m.addConstr(3.54*x0 + 5.02*x1 <= 66, "c6")
    m.addConstr(3.9*x0 + 1.19*x1 <= 93, "c7")
    m.addConstr(6.25*x0 + 9.25*x1 <= 113, "c8")
    m.addConstr(3.72*x0 + 4.65*x1 <= 116, "c9")


    # Optimize model
    m.optimize()

    if m.status == gp.GRB.OPTIMAL:
        print('Obj: %g' % m.objVal)
        for v in m.getVars():
            print('%s %g' % (v.varName, v.x))
    elif m.status == gp.GRB.INFEASIBLE:
        print('Optimization problem is infeasible.')
    else:
        print('Optimization ended with status %d' % m.status)


except gp.GurobiError as e:
    print('Error code ' + str(e.errno) + ': ' + str(e))

except AttributeError:
    print('Encountered an attribute error')
