
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define the variables
    x1 = model.addVar(name="hours_worked_by_Hank", lb=0)
    x2 = model.addVar(name="hours_worked_by_Jean", lb=0)

    # Define the objective function
    model.setObjective(5 * x1 + x2, gurobi.GRB.MAXIMIZE)

    # Define the constraints
    model.addConstr(3.54 * x1 + 5.02 * x2 >= 57)
    model.addConstr(3.9 * x1 + 1.19 * x2 >= 29)
    model.addConstr(6.25 * x1 + 9.25 * x2 >= 63)
    model.addConstr(3.72 * x1 + 4.65 * x2 >= 61)
    model.addConstr(-6 * x1 + x2 >= 0)
    model.addConstr(3.54 * x1 + 5.02 * x2 <= 66)
    model.addConstr(3.9 * x1 + 1.19 * x2 <= 93)
    model.addConstr(6.25 * x1 + 9.25 * x2 <= 113)
    model.addConstr(3.72 * x1 + 4.65 * x2 <= 116)

    # Optimize the model
    model.optimize()

    # Print the status of the model
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Hank: {x1.varValue}")
        print(f"Hours worked by Jean: {x2.varValue}")
        print(f"Objective function value: {model.objVal}")
    elif model.status == gurobi.GRB.Status.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
