
import gurobipy as gp
from gurobipy import GRB

try:
    # Create a new model
    m = gp.Model("nutrition_optimization")

    # Create variables
    fiber = m.addVar(lb=0, name="fiber")  # Grams of fiber
    vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")  # Milligrams of vitamin B4

    # Set objective function
    m.setObjective(8.29 * fiber + 1.45 * vitamin_b4, GRB.MINIMIZE)

    # Add constraints
    m.addConstr(12.24 * fiber + 2.93 * vitamin_b4 >= 10, "muscle_growth_min")
    m.addConstr(6.27 * fiber + 6.76 * vitamin_b4 >= 40, "digestive_support_min")
    m.addConstr(-8 * fiber + 2 * vitamin_b4 >= 0, "fiber_vitamin_ratio")
    m.addConstr(12.24 * fiber + 2.93 * vitamin_b4 <= 17, "muscle_growth_max")
    m.addConstr(6.27 * fiber + 6.76 * vitamin_b4 <= 78, "digestive_support_max")


    # Optimize model
    m.optimize()

    # Print results
    if m.status == GRB.OPTIMAL:
        print(f"Optimal objective value: {m.objVal}")
        print(f"Grams of fiber: {fiber.x}")
        print(f"Milligrams of vitamin B4: {vitamin_b4.x}")
    elif m.status == GRB.INFEASIBLE:
        print("The model is infeasible.")
    else:
        print(f"Optimization terminated with status {m.status}")


except gp.GurobiError as e:
    print(f"Error code {e.errno}: {e}")

except AttributeError:
    print('Encountered an attribute error')
