
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=0, name="grams_of_fiber")  # Grams of fiber
x1 = m.addVar(lb=0, name="milligrams_of_vitamin_B4")  # Milligrams of vitamin B4

# Set the objective function
m.setObjective(8.29*x0 + 1.45*x1, GRB.MINIMIZE)

# Add constraints
m.addConstr(12.24*x0 + 2.93*x1 >= 10, name="min_muscle_growth_index")
m.addConstr(6.27*x0 + 6.76*x1 >= 40, name="min_digestive_support_index")
m.addConstr(-8*x0 + 2*x1 >= 0, name="linear_combination_constraint")
m.addConstr(12.24*x0 + 2.93*x1 <= 17, name="max_muscle_growth_index")
m.addConstr(6.27*x0 + 6.76*x1 <= 78, name="max_digestive_support_index")

# Optimize the model
m.optimize()

# Print the results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of fiber: {x0.x}")
    print(f"Milligrams of vitamin B4: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found")
