
import gurobi

# Define the model
model = gurobi.Model()

# Define the variables
x1 = model.addVar(name="grams_of_fiber", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
x2 = model.addVar(name="milligrams_of_vitamin_B4", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

# Define the objective function
model.setObjective(8.29 * x1 + 1.45 * x2, gurobi.GRB.MINIMIZE)

# Define the constraints
model.addConstr(12.24 * x1 + 2.93 * x2 >= 10, name="muscle_growth_index_min")
model.addConstr(6.27 * x1 + 6.76 * x2 >= 40, name="digestive_support_index_min")
model.addConstr(-8 * x1 + 2 * x2 >= 0, name="vitamin_B4_constraint")
model.addConstr(12.24 * x1 + 2.93 * x2 <= 17, name="muscle_growth_index_max")
model.addConstr(6.27 * x1 + 6.76 * x2 <= 78, name="digestive_support_index_max")

# Optimize the model
model.optimize()

# Print the solution
if model.status == gurobi.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of fiber: {x1.varValue}")
    print(f"Milligrams of vitamin B4: {x2.varValue}")
    print(f"Objective function value: {model.objVal}")
else:
    print("No optimal solution found.")
